# -*- coding: utf-8 -*-
"""r02.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1_yrpsPD-nKtca1JPsdYrvyfhnbbMMBpP

# Rozdział 2.
"""

# importowanie bibliotek
import numpy as np
import matplotlib.pyplot as plt


# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki

"""# Tworzenie wektorów"""

# Wektor w postaci listy Pythona
asList = [1,2,3]

# Te same liczby w postaci jednowymiarowej tablicy numPy
asArray = np.array([1,2,3])

# Te same liczby, ale tym razem z określoną orientacją
rowVec = np.array([ [1,2,3] ]) # wiersz
colVec = np.array([ [1],[2],[3] ]) # kolumna

# Użycie spacji podczas definiowania wektorów nie jest konieczne, ale zwiększa czytelność kodu.

# Sprawdzam kształ zmiennych
print(f'asList:  {np.shape(asList)}') # korzystam z funkcji shape z NumPy
print(f'asArray: {asArray.shape}') # korzystam z atrybutu obiektu NumPy
print(f'rowVec:  {rowVec.shape}')
print(f'colVec:  {colVec.shape}')

"""# Geometryczna interpretacja wektorów"""

v = np.array([-1,2])

plt.arrow(0,0,v[0],v[1],head_width=.5,width=.1)
plt.plot(0,0,'ko',markerfacecolor='k',markersize=7)

plt.plot([-3,3],[0,0],'--',color=[.8,.8,.8],zorder=-1)
plt.plot([0,0],[-3,3],'--',color=[.8,.8,.8],zorder=-1)

plt.axis('square')
plt.axis([-3,3,-3,3])
plt.xlabel('$v_0$')
plt.ylabel('$v_1$')
plt.title('Wektor v w pozycji standardowej')
plt.show()

startPos = [
            [0,0],
            [-1,-1],
            [1.5,-2]
            ]



fig = plt.figure(figsize=(6,6))

for s in startPos:


  plt.arrow(s[0],s[1],v[0],v[1],head_width=.5,width=.1,color='black')
  plt.plot(s[0],s[1],'ko',markerfacecolor='k',markersize=7)


  if s==[0,0]:
    plt.text(v[0]+.1,v[1]+.2,' „Pozycja standardowa”')


plt.plot([-3,3],[0,0],'--',color=[.8,.8,.8],zorder=-1)
plt.plot([0,0],[-3,3],'--',color=[.8,.8,.8],zorder=-1)


plt.axis('square')
plt.axis([-3,3,-3,3])
plt.xlabel('$v_0$')
plt.ylabel('$v_1$')
plt.title('Wektor $\mathbf{v}$ w kilku lokalizacjach')
plt.savefig('rys2.1.png',dpi=300)
plt.show()

"""# Dodawanie wektorów"""

# Przykład z książki
v = np.array([4,5,6])
w = np.array([10,20,30])
u = np.array([0,3,6,9])
vPlusW = v+w
uPlusW = u+w # Błąd! Niezgodność wymiarów!

# Wykorzystuję wektory 2D, aby uprościć wizualizację
v = np.array([1,2])
w = np.array([4,-6])
vPlusW = v+w

print(v)
print(w)
print(vPlusW)

# Kod generujący rysunek 3.2 jest tematem zadania 1.

"""# Odejmowanie wektorów"""

vMinusW = v-w

print(v)
print(w)
print(vMinusW)

"""# Mnożenie wektora przez skalar"""

s= 2
a = [3,4,5] # lista
b = np.array(a) # tablica NumPy
print(a*s)
print(b*s)

s = 3.5

print(v)
print(s+v)

plt.plot([0,b[0]],[0,b[1]],'m--',linewidth=3,label='b')
plt.plot([0,s*b[0]],[0,s*b[1]],'k:',linewidth=3,label='sb')

plt.grid()
plt.axis('square')
plt.axis([-6,6,-6,6])
plt.legend()
plt.show()

scalars = [ 1, 2, 1/3, 0, -2/3 ]

baseVector = np.array([ .75,1 ])

fig,axs = plt.subplots(1,len(scalars),figsize=(12,3))
i = 0

for s in scalars:


  v = s*baseVector

  axs[i].arrow(0,0,baseVector[0],baseVector[1],head_width=.3,width=.1,color='k',length_includes_head=True)
  axs[i].arrow(.1,0,v[0],v[1],head_width=.3,width=.1,color=[.75,.75,.75],length_includes_head=True)
  axs[i].grid(linestyle='--')
  axs[i].axis('square')
  axs[i].axis([-2.5,2.5,-2.5,2.5])
  axs[i].set(xticks=np.arange(-2,3), yticks=np.arange(-2,3))
  axs[i].set_title(f'$\sigma$ = {s:.2f}')
  i+=1

plt.tight_layout()
plt.savefig('rys2.3.png',dpi=300)
plt.show()

"""# Transpozycja"""

r = np.array([ [1,2,3] ])
l = np.array([1,2,3])

print(r), print(' ')

print(r.T), print(' ')

print(r.T.T)

print(l), print(' ')
print(l.T), print(' ')
print(l.T.T)

"""# Broadcasting"""

v = np.array([[1,2,3]]).T # wektor kolumnowy
w = np.array([[10,20]])   # wektor wierszowy
v + w # dodawanie z użyciem broadcastingu

"""# Moduł wektora"""

v = np.array([1,2,3,7,8,9])
v_dim = len(v)  # wymiarowość w sensie matematycznym
v_mag = np.linalg.norm(v) # moduł, długość geometryczna lub norma

"""# Iloczyn skalarny"""

v = np.array([1,2,3,4])
w = np.array([5,6,7,8])
np.dot(v,w)

"""# Iloczyn skalarny jest rozdzielny względem dodawania"""

v = np.array([ 0,1,2 ])
w = np.array([ 3,5,8 ])
u = np.array([ 13,21,34 ])

# iloczyn skalarny jest rozdzielny względem dodawania
res1 = np.dot( v, w+u )
res2 = np.dot( v,w ) + np.dot( v,u )

res1,res2

"""# Rozwiązania do zadań

# Ćwiczenia 1.
"""

# definiowanie wektorów
v = np.array([1,2])
w = np.array([4,-6])
vPlusW = v+w


# wykreślanie
plt.figure(figsize=(6,6))

a1 = plt.arrow(0,0,v[0],v[1],head_width=.3,width=.1,color='k',length_includes_head=True)
a2 = plt.arrow(v[0],v[1],w[0],w[1],head_width=.3,width=.1,color=[.5,.5,.5],length_includes_head=True)
a3 = plt.arrow(0,0,vPlusW[0],vPlusW[1],head_width=.3,width=.1,color=[.8,.8,.8],length_includes_head=True)


# poprawa wyglądu
plt.grid(linestyle='--',linewidth=.5)
plt.axis('square')
plt.axis([-6,6,-6,6])
plt.legend([a1,a2,a3],['v','w','v+w'])
plt.title('Wektory $\mathbf{v}$, $\mathbf{w}$ i $\mathbf{v+w}$')
plt.savefig('rys2.2a.png',dpi=300) # zapis rysunku do pliku
plt.show()

# różnica wektorów
vMinusW = v-w


# wykreślanie
plt.figure(figsize=(6,6))

a1 = plt.arrow(0,0,v[0],v[1],head_width=.3,width=.1,color='k',length_includes_head=True)
a2 = plt.arrow(0,0,w[0],w[1],head_width=.3,width=.1,color=[.5,.5,.5],length_includes_head=True)
a3 = plt.arrow(w[0],w[1],vMinusW[0],vMinusW[1],head_width=.3,width=.1,color=[.8,.8,.8],length_includes_head=True)


# poprawa wyglądu
plt.grid(linestyle='--',linewidth=.5)
plt.axis('square')
plt.axis([-6,6,-6,6])
plt.legend([a1,a2,a3],['v','w','v-w'])
plt.title('Wektory $\mathbf{v}$, $\mathbf{w}$ i $\mathbf{v-w}$')
plt.savefig('rys2.2b.png',dpi=300)
plt.show()

"""# Ćwiczenie 2."""

def normOfVect(v):
  return np.sqrt(np.sum(v**2))

w = np.array([0,0,1])
print( normOfVect(w) )

w = np.array([1,2,3])
print( normOfVect(w),np.linalg.norm(w) )

"""# Ćwiczenie 3."""

def createUnitVector(v):
  mu = np.linalg.norm(v)
  return v / mu


w = np.array([0,1,0])
print( createUnitVector(w) )

w = np.array([0,3,0])
print( createUnitVector(w) )

w = np.array([13,-5,7])
uw = createUnitVector(w)
print( uw ), print(' ')

print( np.linalg.norm(w),np.linalg.norm(uw) )

print('\n\n\n')
createUnitVector( np.zeros((4,1)) )

"""# Ćwiczenie 4."""

def createMagVector(v,mag):
  mu = np.linalg.norm(v)
  return mag * v / mu

w = np.array([1,0,0])
mw = createMagVector(w,4)
print( mw )

print( np.linalg.norm(w),np.linalg.norm(mw) )

"""# Ćwiczenie 5."""

v = np.array([[1,2,3]])

vt = np.zeros((3,1))

for i in range(v.shape[1]):
  vt[i,0] = v[0,i]

print(v), print(' ')
print(vt)

"""# Ćwiczenie 6."""

c = np.random.randn(5)
sqrNrm1 = np.dot(c,c)
sqrNrm2 = normOfVect(c)**2

print( sqrNrm1 )
print( sqrNrm2 )

"""# Ćwiczenie 7."""

n = 11

a = np.random.randn(n,1)
b = np.random.randn(n,1)

atb = np.sum(a*b)
bta = np.sum(b*a)

atb - bta

"""# Ćwiczenie 8."""

a = np.array([1,2])
b = np.array([1.5,.5])

beta = np.dot(a,b) / np.dot(a,a)

projvect = b - beta*a


# rysowanie wykresu
plt.figure(figsize=(4,4))

plt.arrow(0,0,a[0],a[1],head_width=.2,width=.02,color='k',length_includes_head=True)
plt.arrow(0,0,b[0],b[1],head_width=.2,width=.02,color='k',length_includes_head=True)

plt.plot([b[0],beta*a[0]],[b[1],beta*a[1]],'k--')

plt.plot(beta*a[0],beta*a[1],'ko',markerfacecolor='w',markersize=13)

plt.plot([-1,2.5],[0,0],'--',color='gray',linewidth=.5)
plt.plot([0,0],[-1,2.5],'--',color='gray',linewidth=.5)

plt.text(a[0]+.1,a[1],'a',fontweight='bold',fontsize=18)
plt.text(b[0],b[1]-.3,'b',fontweight='bold',fontsize=18)
plt.text(beta*a[0]-.35,beta*a[1],r'$\beta$',fontweight='bold',fontsize=18)
plt.text((b[0]+beta*a[0])/2,(b[1]+beta*a[1])/2+.1,r'(b-$\beta$a)',fontweight='bold',fontsize=18)

plt.axis('square')
plt.axis([-1,2.5,-1,2.5])
plt.savefig('rys2.6.png', dpi=300)

"""# Ćwiczenie 9."""

t = np.random.randn(2)
r = np.random.randn(2)

t_para = r * (np.dot(t,r) / np.dot(r,r))
t_perp = t - t_para

print(t)
print( t_para+t_perp )

print( np.dot(t_para,t_perp) )
# Uwaga: ze względu na sposób działania typu float możesz otrzymać wyniki typu 10^-17. Należy je traktować tak jak zero.



plt.figure(figsize=(6,6))

plt.plot([0,t[0]],[0,t[1]],color='k',linewidth=3,label=r'$\mathbf{t}$')
plt.plot([0,r[0]],[0,r[1]],color=[.7,.7,.7],linewidth=3,label=r'$\mathbf{r}$')

plt.plot([0,t_para[0]],[0,t_para[1]],'k--',linewidth=3,label=r'$\mathbf{t}_{\|}$')
plt.plot([0,t_perp[0]],[0,t_perp[1]],'k:',linewidth=3,label=r'$\mathbf{t}_{\perp}$')

plt.axis('equal')
plt.legend()
plt.savefig('rys.2.8.png',dpi=300)

"""# Ćwiczenie 10."""

# Zastąp t_para w poprzednim ćwiczeniu następującą linią:
t_para = r * (np.dot(t,r) / np.dot(t,t))